/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

public enum ModeTree {
    treeMedian,
    treeMiddle,
    treeMean,
    treeFirst;


    public static ModeTree getDefault(int bitpix) {
        return bitpix == 0 ? treeMedian : treeMean;
    }

    public static String contains(String test) {
        if (test == null) {
            return null;
        }
        test = test.toUpperCase();
        for (ModeTree c : ModeTree.values()) {
            if (!c.name().toUpperCase().endsWith(test)) continue;
            return c.name();
        }
        return null;
    }

    public static String list() {
        StringBuilder s = new StringBuilder();
        for (ModeTree m : ModeTree.values()) {
            if (s.length() > 0) {
                s.append('|');
            }
            s.append(m.toString());
        }
        return s.toString();
    }

    public static String getExplanation(ModeTree m) {
        if (m == treeMedian) {
            return (Object)((Object)m) + ": The median of the 4 sublevel pixel values";
        }
        if (m == treeMiddle) {
            return (Object)((Object)m) + ": One of the two intermediate values amongs the 4 sublevel pixel values";
        }
        if (m == treeMean) {
            return (Object)((Object)m) + ": The mean of the 4 sublevel pixel values";
        }
        if (m == treeFirst) {
            return (Object)((Object)m) + ": The first of the 4 sublevel pixel values";
        }
        return "";
    }
}

